<?php
namespace Box\Mod\Contabomanager\Controller;
use FOSSBilling\InjectionAwareInterface;
use Pimple\Container;

class Admin implements InjectionAwareInterface {
    protected $di;
    public function setDi(Container $di): void { $this->di = $di; }
    public function getDi(): ?Container { return $this->di; }

    public function fetchNavigation(): array {
        return ['subpages' => [['location' => 'system', 'index' => 1000, 'label' => 'Contabo Manager', 'uri' => $this->di['url']->adminLink('contabomanager')]]];
    }

    public function register($app): void {
        $app->get('/contabomanager', 'get_index', [], get_class($this));
        $app->get('/contabomanager/api', 'get_api', [], get_class($this));
        $app->post('/contabomanager/save', 'post_save', [], get_class($this));
        $app->post('/contabomanager/import', 'post_import', [], get_class($this));
        $app->get('/contabomanager/action/:id/:type', 'get_action', ['id' => '[a-z0-9-]+', 'type' => '[a-z]+'], get_class($this));
    }

    public function get_index($app) {
        $s = $this->di['pdo']->query("SELECT * FROM mod_contabomanager_settings WHERE id = 1")->fetch();
        $orders = $this->di['db']->find('ClientOrder', 'status = "active" order by id desc');
        return $app->render('mod_contabomanager_index', ['settings' => $s, 'orders' => $orders]);
    }

    public function post_save($app) {
        $stmt = $this->di['pdo']->prepare("REPLACE INTO mod_contabomanager_settings (id, client_id, client_secret, api_username, api_password, updated_at) VALUES (1, ?, ?, ?, ?, NOW())");
        $stmt->execute([$_POST['client_id'], $_POST['client_secret'], $_POST['api_username'], $_POST['api_password']]);
        header("Location: " . $this->di['url']->adminLink('contabomanager', ['msg' => 'Settings Updated']));
        exit;
    }

    public function post_import($app) {
        $order_id = $_POST['order_id'] ?? '';
        $instance_id = $_POST['instance_id'] ?? null;
        if ($instance_id) {
            if (empty($order_id)) {
                $this->di['pdo']->prepare("DELETE FROM mod_contabomanager_instances WHERE instance_id = ?")->execute([$instance_id]);
                $msg = 'Assignment Removed';
            } else {
                $order = $this->di['db']->load('ClientOrder', $order_id);
                $this->di['pdo']->prepare("REPLACE INTO mod_contabomanager_instances (instance_id, client_id, order_id) VALUES (?, ?, ?)")
                     ->execute([$instance_id, $order->client_id, $order_id]);
                $msg = 'Assigned to Order #' . $order_id;
            }
        }
        header("Location: " . $this->di['url']->adminLink('contabomanager', ['msg' => $msg]));
        exit;
    }

    public function get_api($app) {
        header('Content-Type: application/json');
        try {
            $assigned = $this->di['pdo']->query("SELECT instance_id, order_id FROM mod_contabomanager_instances")->fetchAll(\PDO::FETCH_KEY_PAIR);
            require_once __DIR__ . '/../Service.php';
            $service = new \Box\Mod\Contabomanager\Service();
            $service->setDi($this->di);
            $instances = $service->getInstances();
            foreach($instances as &$ins) {
                $ins['assigned_order'] = $assigned[$ins['instanceId']] ?? null;
            }
            echo json_encode($instances);
        } catch (\Exception $e) { echo json_encode(['error' => $e->getMessage()]); }
        exit;
    }

    public function get_action($app, $id, $type) {
        try {
            require_once __DIR__ . '/../Service.php';
            $service = new \Box\Mod\Contabomanager\Service();
            $service->setDi($this->di);
            $service->postAction($id, $type);
            header("Location: " . $this->di['url']->adminLink('contabomanager', ['msg' => 'Command Sent']));
        } catch (\Exception $e) { header("Location: " . $this->di['url']->adminLink('contabomanager', ['error' => $e->getMessage()])); }
        exit;
    }
}
